/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.ast;

import icyllis.flexmark.ast.LinkNodeBase;
import icyllis.flexmark.util.ast.DoNotLinkDecorate;
import icyllis.flexmark.util.ast.NodeVisitor;
import icyllis.flexmark.util.ast.TextContainer;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.Escaping;
import icyllis.flexmark.util.sequence.ReplacedTextMapper;
import icyllis.flexmark.util.sequence.builder.ISequenceBuilder;

public abstract class LinkNode
extends LinkNodeBase
implements DoNotLinkDecorate,
TextContainer {
    public LinkNode() {
    }

    public LinkNode(BasedSequence chars) {
        super(chars);
    }

    @Override
    public boolean collectText(ISequenceBuilder<? extends ISequenceBuilder<?, BasedSequence>, BasedSequence> out, int flags, NodeVisitor nodeVisitor) {
        BasedSequence url;
        int urlType = flags & F_LINK_TEXT_TYPE;
        switch (urlType) {
            case 1: {
                url = this.getPageRef();
                break;
            }
            case 2: {
                url = this.getAnchorRef();
                break;
            }
            case 3: {
                url = this.getUrl();
                break;
            }
            case 4: {
                url = BasedSequence.NULL;
                break;
            }
            default: {
                return true;
            }
        }
        if (urlType == 4) {
            out.append(this.getChars());
        } else {
            ReplacedTextMapper textMapper = new ReplacedTextMapper(url);
            BasedSequence unescaped = Escaping.unescape(url, textMapper);
            BasedSequence percentDecoded = Escaping.percentDecodeUrl(unescaped, textMapper);
            out.append(percentDecoded);
        }
        return false;
    }
}

